//
//  TTTBoard.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/3/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTBoard.h"
#import "TTTSymbol.h"
#import "TTTGameGrid.h"
#import "TTTGameSessionViewController.h"

#define TTTBOARDLOCATIONINVIEWX 10
#define TTTBOARDLOCATIONINVIEWY 10
#define TTTBOARDSIZE 200

@implementation TTTBoard

    - (id)initWithFrame:(CGRect)frame{
        self = [super initWithFrame:frame];
        if (self) {
            // Initialization code
        }
        return self;
    }

    - (float) getWidth{
        width = TTTBOARDSIZE/3.0;         // width of one block
        return width;
    }

    - (float) getHeight{
        height = TTTBOARDSIZE/3.0;         // will be same as width;
        return height;
    }

    // Drawing code
    - (void)drawRect:(CGRect)rect {
        int gridSize = TTTBOARDSIZE;
        
        UIBezierPath *drawingPath = [UIBezierPath bezierPath];
        // draw vertical lines
        for(int i=0; i <= 3; i++) {
            int x = TTTBOARDLOCATIONINVIEWX + [self getWidth]*i;
            [drawingPath moveToPoint:CGPointMake(x, TTTBOARDLOCATIONINVIEWY)];
            [drawingPath addLineToPoint:CGPointMake(x, TTTBOARDLOCATIONINVIEWY + gridSize)];
        }
    
        // draw horizontal lines
        for(int j = 0; j <= 3; j++) {
            int y = TTTBOARDLOCATIONINVIEWY + j * [self getHeight];
            [drawingPath moveToPoint:CGPointMake(TTTBOARDLOCATIONINVIEWX, y)];
            [drawingPath addLineToPoint:CGPointMake(TTTBOARDLOCATIONINVIEWX + gridSize, y)];
        }
    
        [[UIColor redColor] setStroke];
    
        [drawingPath stroke];

        // Draw the symbols
        
        float offsetX = 0;
		float offsetY = 0;
		for(int i = 0; i < GAMEGRIDSIZE; i++){
			for(int j = 0; j < GAMEGRIDSIZE; j++){
				UIImage *imageSelected = [[grid getValueAtLocation :i :j] getBitmapForSymbol];
                CGSize imageSize = [imageSelected size];
				offsetX = TTTBOARDLOCATIONINVIEWX + (int) (width * i + (width - imageSize.width)/2);
				offsetY = TTTBOARDLOCATIONINVIEWY + (int) (height * j + (height - imageSize.height)/2) ;
                
                [imageSelected drawAtPoint:CGPointMake(offsetX, offsetY)];
			}
		}

    }

    - (void) setGrid: (TTTGameGrid *) aGrid{
        grid = aGrid;
    }

    - (void) setGameSession: (TTTGameSessionViewController *) aGameSession{
        gameSession = aGameSession;
    }

    - (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event{
        if (self->enabled){
            [super touchesBegan:touches withEvent:event];
        
            NSSet* touchesInView = [event touchesForView:self];
            UITouch* touchInGrid = (UITouch *)[touchesInView anyObject];
            CGPoint touchPoint = [touchInGrid locationInView:self];
            float x = touchPoint.x-TTTBOARDLOCATIONINVIEWX;
            float y = touchPoint.y-TTTBOARDLOCATIONINVIEWX;
            [gameSession boardTouchedAt:x :y];
        }
    }

    - (void) invalidateBlock: (int) x :(int) y {
        [self setNeedsDisplay];
    }

    - (BOOL) isInputEnabled{
        return self->enabled;
    }

    - (void) disableInput {
        self->enabled = NO;
    }

    - (void) enableInput{
        self->enabled = YES;
    }

@end
